/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.updates;

import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.BigNumberComparator;
import com.ibm.hsc.websm.updates.AllFixPackDataFilter;
import com.ibm.hsc.websm.updates.CommonMarkerLID;
import com.ibm.hsc.websm.updates.CoverLetterInformation;
import com.ibm.hsc.websm.updates.NewECStreamFilter;
import com.ibm.hsc.websm.updates.PICoverLetterFilter;
import com.ibm.hsc.websm.updates.PIFixPackFilter;
import com.ibm.hsc.websm.updates.PIUpdateErrorIds;
import com.ibm.hsc.websm.updates.PIUpdateException;
import com.ibm.hsc.websm.updates.PIUpdatesOwner;
import com.ibm.hsc.websm.updates.TargettedFsp;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.cim.UnsignedInt8;

public class PIUpdateableComponent
extends UpdateableComponent
implements PIUpdateErrorIds {
    private static final String TRACE_MASKT = "XUPDCOMT";
    private static final String TRACE_MASKF = "XUPDCOMF";
    private static final String TRACE_MASKD = "XUPDCOMD";
    public static final int EMERGENCY_FIXPACK_NUMBER = 900;
    public static final String CONCURRENT_PATCHING_ALLOWED = "concurrent.ok";
    private int applyInProgressLevel;
    private Date applyInProgressDate;
    private int appliedLevel;
    private Date appliedDate;
    private int committedLevel;
    private Date committedDate;
    private File concurrentEnabledFile;
    private LocalizableText Description;
    private String ecNumber;
    private TargettedFsp fsp;
    private String mtms;
    private String name;
    private String newGAEcStream;
    private String newGenusEcStream;
    private String packageIdentifier;
    private int stagedLevel;
    private Date stagedDate;
    private int stagableLevel;
    private int nonDisruptiveStagableLevel;
    private int nonDisruptivePartialApplyLevel;
    private int nonDisruptiveApplyLevel;
    private int nonDisruptiveRejectLevel;
    private boolean somethingStagable;
    private static Integer stagableLock = new Integer(0);
    private boolean somethingStaged;
    private static Integer stagedLock = new Integer(0);
    private String stagableCoverLetter;
    private String stagedCoverLetter;
    private LocalizableText updatingDisabledReason;
    private List updateCollections;

    public PIUpdateableComponent(PIUpdatesOwner pIUpdatesOwner, TargettedFsp targettedFsp, String string) throws HException {
        super((UpdatesOwner)pIUpdatesOwner);
        Trace.trace((String)TRACE_MASKT, (Object)"->PIUpdateableComponent()");
        this.fsp = targettedFsp;
        this.name = string;
        this.newGAEcStream = null;
        this.newGenusEcStream = null;
        this.appliedLevel = 0;
        this.applyInProgressLevel = 0;
        this.committedLevel = -1;
        this.nonDisruptiveApplyLevel = -1;
        this.nonDisruptivePartialApplyLevel = -1;
        this.nonDisruptiveRejectLevel = -1;
        this.nonDisruptiveStagableLevel = -1;
        this.stagableLevel = -1;
        this.updatingDisabledReason = new LocalizableText("Reason unknown.");
        this.somethingStagable = false;
        this.somethingStaged = false;
        String string2 = pIUpdatesOwner.getDataArea();
        string2 = string2 + CONCURRENT_PATCHING_ALLOWED;
        this.concurrentEnabledFile = new File(string2);
        if (string.equals("CEC") || string.equals("CPC")) {
            this.packageIdentifier = "01";
            this.name = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "MANAGED_SYSTEM").toString();
        } else {
            this.packageIdentifier = "02";
            this.name = new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "POWER_SUBSYSTEM").toString();
        }
        this.updateCollections = new ArrayList();
        this.setHMCandCECLevels();
        this.nonDisruptiveStagableLevel = this.nonDisruptiveApplyLevel;
        this.stagableLevel = this.stagedLevel;
        Trace.trace((String)TRACE_MASKT, (Object)"<-PIUpdateableComponent()");
    }

    public String getECNumber() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getECNumber()");
        return this.ecNumber;
    }

    public LocalizableText getDescription() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getDescription()");
        return this.Description;
    }

    public void setDescription(LocalizableText localizableText) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setDescription()");
        this.Description = localizableText;
    }

    public TargettedFsp getFsp() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getFsp()");
        return this.fsp;
    }

    public String getMTMS() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getMTMS()");
        return this.mtms;
    }

    public void setMTMS(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setMTMS()");
        this.mtms = string;
    }

    public String getName() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getName()");
        return this.name;
    }

    public String getNewGAEcStream() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getNewGAEcStream()");
        return this.newGAEcStream;
    }

    private void setNewGAEcStream(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("<>setNewGAEcStream(" + string + ")"));
        this.newGAEcStream = string;
    }

    public String getNewGenusEcStream() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getNewGenusEcStream()");
        return this.newGenusEcStream;
    }

    private void setNewGenusEcStream(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("<>setNewGenusEcStream(" + string + ")"));
        this.newGenusEcStream = string;
    }

    public int getCommittedLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getCommittedLevel()");
        return this.committedLevel;
    }

    public Date getCommittedDate() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getCommittedDate()");
        return this.committedDate;
    }

    public void setCommittedInfo(int n, Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setCommittedInfo()");
        this.committedLevel = n;
        this.committedDate = date;
    }

    public int getApplyInProgressLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getApplyInProgressLevel()");
        return this.applyInProgressLevel;
    }

    public Date getApplyInProgressDate() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getApplyInProgressDate()");
        return this.applyInProgressDate;
    }

    public void setApplyInProgressInfo(int n, Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setApplyInProgressInfo()");
        this.applyInProgressLevel = n;
        this.applyInProgressDate = date;
    }

    public int getAppliedLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getAppliedLevel()");
        return this.appliedLevel;
    }

    public Date getAppliedDate() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getAppliedDate()");
        return this.appliedDate;
    }

    public void setAppliedInfo(int n, Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setAppliedInfo()");
        this.appliedLevel = n;
        this.appliedDate = date;
    }

    public int getStagedLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getStagedLevel()");
        return this.stagedLevel;
    }

    public Date getStagedDate() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getStagedDate()");
        return this.stagedDate;
    }

    public void setStagedInfo(int n, Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setStagedInfo()");
        this.stagedLevel = n;
        Trace.trace((String)TRACE_MASKD, (Object)("Set the staged level to " + this.stagedLevel));
        this.stagedDate = date;
    }

    public int getStagableLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getStagableLevel()");
        Trace.trace((String)TRACE_MASKD, (Object)("Stagable level = " + this.stagableLevel));
        return this.stagableLevel;
    }

    public void setStagableInfo(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setStagableInfo()");
        this.stagableLevel = n;
        Trace.trace((String)TRACE_MASKD, (Object)("Set the stagable level to " + this.stagableLevel));
    }

    public int getNonDisruptiveStagableLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"->getNonDisruptiveStagableLevel()");
        Trace.trace((String)TRACE_MASKD, (Object)("Nondisruptive stagable level = " + this.nonDisruptiveStagableLevel));
        int n = this.nonDisruptiveStagableLevel;
        if (!this.concurrentEnabledFile.exists()) {
            n = -1;
            Trace.trace((String)TRACE_MASKF, (Object)("Concurrent patching disabled. level = " + n));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-getNonDisruptiveStagableLevel()");
        return n;
    }

    public void setNonDisruptiveStagableInfo(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setNonDisruptiveStagableInfo()");
        this.nonDisruptiveStagableLevel = n;
        Trace.trace((String)TRACE_MASKD, (Object)("Set the nondisruptive stagable level to " + this.nonDisruptiveStagableLevel));
    }

    public int getNonDisruptivePartialApplyLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"->getNonDisruptivePartialApplyLevel()");
        int n = this.nonDisruptivePartialApplyLevel;
        if (!this.concurrentEnabledFile.exists()) {
            n = -1;
            Trace.trace((String)TRACE_MASKF, (Object)("Concurrent patching disabled. level = " + n));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-getNonDisruptivePartialApplyLevel()");
        return n;
    }

    public void setNonDisruptivePartialApplyInfo(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setNonDisruptivePartialApplyInfo()");
        this.nonDisruptivePartialApplyLevel = n;
    }

    public int getNonDisruptiveApplyLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"->getNonDisruptiveApplyLevel()");
        int n = this.nonDisruptiveApplyLevel;
        if (!this.concurrentEnabledFile.exists()) {
            n = -1;
            Trace.trace((String)TRACE_MASKF, (Object)("Concurrent patching disabled. level = " + n));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-getNonDisruptiveApplyLevel()");
        return n;
    }

    public void setNonDisruptiveApplyInfo(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setNonDisruptiveApplyInfo()");
        this.nonDisruptiveApplyLevel = n;
    }

    public int getNonDisruptiveRejectLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"->getNonDisruptiveRejectLevel()");
        int n = this.nonDisruptiveRejectLevel;
        if (!this.concurrentEnabledFile.exists()) {
            n = -1;
            Trace.trace((String)TRACE_MASKF, (Object)("Concurrent patching disabled. level = " + n));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-getNonDisruptiveRejectLevel()");
        return n;
    }

    public void setNonDisruptiveRejectInfo(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setNonDisruptiveRejectInfo()");
        this.nonDisruptiveRejectLevel = n;
    }

    public String getStagableCoverLetter() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getStagableCoverLetter()");
        return this.stagableCoverLetter;
    }

    public List getStagableCoverLetterInfo() throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"->getStagableCoverLetterInfo()");
        List list = this.getStagableCoverLetterInfo(this.stagableLevel);
        Trace.trace((String)TRACE_MASKT, (Object)"<-getStagableCoverLetterInfo()");
        return list;
    }

    public List getStagableCoverLetterInfo(int n) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)("->getStagableCoverLetterInfo(" + n + ")"));
        ArrayList<CoverLetterInformation> arrayList = new ArrayList<CoverLetterInformation>();
        PIUpdatesOwner pIUpdatesOwner = (PIUpdatesOwner)super.getOwner();
        String string = pIUpdatesOwner.getDataArea();
        int n2 = n;
        int n3 = this.appliedLevel;
        if (n <= this.appliedLevel) {
            n2 = this.appliedLevel;
            n3 = n;
        }
        string = string + this.stagableCoverLetter;
        Trace.trace((String)TRACE_MASKD, (Object)("coverLetter=[" + string + "]"));
        File file = new File(string);
        if (!file.exists()) {
            pIUpdatesOwner.importStagableCoverLetters();
        }
        for (int i = n3; i <= n2; ++i) {
            CoverLetterInformation coverLetterInformation = new CoverLetterInformation(file, i, this.appliedLevel);
            arrayList.add(coverLetterInformation);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-getStagableCoverLetterInfo()");
        return arrayList;
    }

    public boolean isUpdatingEnabled() {
        Trace.trace((String)TRACE_MASKT, (Object)"->isUpdatingEnabled()");
        boolean bl = false;
        File file = new File("/opt/ccfw/data/overrides/HmcOwner");
        try {
            if (file.exists()) {
                String string = PIUpdatesOwner.readFileIntoString(file);
                if (string.equals("H")) {
                    bl = true;
                }
                if (string.equals("Y")) {
                    bl = true;
                }
            } else {
                String string = "Master";
                Trace.trace((String)TRACE_MASKD, (Object)("Calling getCodeUpdateStatus target=" + string));
                Vector vector = this.fsp.getCodeUpdateStatus(string);
                Trace.trace((String)TRACE_MASKD, (Object)"getCodeUpdateStatus completed successfully");
                Trace.trace((String)TRACE_MASKD, (Object)("results.size()=" + vector.size()));
                UnsignedInt8 unsignedInt8 = vector.elementAt(0) instanceof CIMValue ? (UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue() : (UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                Trace.trace((String)TRACE_MASKD, (Object)("owner=" + unsignedInt8));
                UnsignedInt8 unsignedInt82 = new UnsignedInt8(1);
                if (unsignedInt8.equals((Object)unsignedInt82)) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            PIUpdateException pIUpdateException = new PIUpdateException(-1883, exception);
            bl = false;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isUpdatingEnabled() returns " + (bl ? "true" : "false")));
        return bl;
    }

    public boolean isConcurrentUpdatingEnabled() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> isConcurrentUpdatingEnabled()");
        boolean bl = false;
        try {
            bl = PIUpdatesOwner.isTSideActive(this.fsp);
        }
        catch (HException hException) {
            Trace.trace((String)TRACE_MASKF, (Object)("Unable to get information about FSP " + (Object)((Object)hException)));
        }
        if (!bl) {
            String string = new String("com.ibm.hsc.common.bundles.UpdatesBundleMessages");
            String string2 = new String("UPD0012");
            this.setUpdatingDisabledReason((LocalizableText)new MessageText(string, string2));
            Trace.trace((String)TRACE_MASKD, (Object)("updatingDisabledReason=[" + this.updatingDisabledReason + "]"));
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- isConcurrentUpdatingEnabled() returns " + (bl ? "true" : "false")));
        return bl;
    }

    public LocalizableText getUpdatingDisabledReason() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>getUpdatingDisabledReason()");
        return this.updatingDisabledReason;
    }

    public void setUpdatingDisabledReason(LocalizableText localizableText) {
        Trace.trace((String)TRACE_MASKT, (Object)"<>setUpdatingDisabledReason()");
        this.updatingDisabledReason = localizableText;
    }

    public boolean isRemoteSupportSystemAvailable() {
        Trace.trace((String)TRACE_MASKT, (Object)"<>isRemoteSupportSystemAvailable()");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSomethingStaged() {
        Integer n = stagedLock;
        synchronized (n) {
            boolean bl = this.somethingStaged;
            Trace.trace((String)TRACE_MASKT, (Object)("<- isSomethingStaged() returns " + (bl ? "true" : "false")));
        }
        return this.somethingStaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSomethingStagable() {
        Integer n = stagableLock;
        synchronized (n) {
            boolean bl = this.somethingStagable;
            Trace.trace((String)TRACE_MASKT, (Object)("<- isSomethingStagable() returns " + (bl ? "true" : "false")));
        }
        return this.somethingStagable;
    }

    public List getCommittedUpdates() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getCommittedUpdates()");
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List getUncollectedUpdates() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> getUncollectedUpdates()");
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List getUpdateCollections() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> getUpdateCollections");
        ArrayList arrayList = new ArrayList(this.updateCollections);
        Trace.trace((String)TRACE_MASKT, (Object)("<- getUpdateCollections returns " + this.updateCollections.size() + " collections."));
        return arrayList;
    }

    public void resetStagableLevels() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> resetStagableLevels()");
        this.updateCollections = new ArrayList();
        this.setStagedLevel();
        int n = this.stagedLevel;
        int n2 = this.nonDisruptiveApplyLevel;
        this.stagableCoverLetter = this.stagedCoverLetter;
        Trace.trace((String)TRACE_MASKD, (Object)("Setting stagable level to " + n + " stagable concurrent to " + n2));
        this.setStagableInfo(n);
        this.setNonDisruptiveStagableInfo(n2);
        Trace.trace((String)TRACE_MASKT, (Object)"<- resetStagableLevels()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStagedLevel() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> setStagedLevel()");
        Integer n = stagedLock;
        synchronized (n) {
            int n2 = this.appliedLevel;
            int n3 = this.appliedLevel;
            this.stagedCoverLetter = null;
            Date date = new Date();
            Date date2 = new Date();
            PIUpdatesOwner pIUpdatesOwner = (PIUpdatesOwner)super.getOwner();
            String string = pIUpdatesOwner.getDataArea();
            Trace.trace((String)TRACE_MASKD, (Object)("dataArea = [" + string + "]"));
            File file = new File(string);
            String[] stringArray = file.list(new PIFixPackFilter(this.ecNumber, -1, false, this.appliedLevel));
            String[] stringArray2 = file.list(new PICoverLetterFilter(this.ecNumber, -1));
            this.somethingStaged = false;
            if (stringArray != null && stringArray2 != null) {
                Trace.trace((String)TRACE_MASKD, (Object)("Length of dataFiles=" + stringArray.length));
                Trace.trace((String)TRACE_MASKD, (Object)("Length of coverFiles=" + stringArray2.length));
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].substring(0, 16);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        Trace.trace((String)TRACE_MASKD, (Object)("Comparing [" + stringArray[i] + "] to [" + stringArray2[j] + "]"));
                        if (!stringArray2[j].startsWith(string2)) continue;
                        int n4 = Integer.parseInt(stringArray[i].substring(8, 11));
                        Trace.trace((String)TRACE_MASKD, (Object)("level2= " + n4));
                        String[] stringArray3 = file.list(new AllFixPackDataFilter(this.ecNumber, n4, n4));
                        if (stringArray3.length <= 5) continue;
                        int n5 = Integer.parseInt(stringArray[i].substring(12, 15));
                        Trace.trace((String)TRACE_MASKD, (Object)("lastDisruptive= " + n5));
                        if (n4 > n2) {
                            n2 = n4;
                            File file2 = new File(string + stringArray[i]);
                            date = new Date(file2.lastModified());
                            this.stagedCoverLetter = stringArray2[j];
                            Trace.trace((String)TRACE_MASKD, (Object)("this.stagableCoverLetter set to " + this.stagableCoverLetter));
                        }
                        if (n4 > n3 && n5 <= this.appliedLevel) {
                            n3 = n4;
                        }
                        if (n4 >= this.appliedLevel) {
                            this.somethingStaged = true;
                        }
                        this.addUpdateCollectionLevel(n4);
                    }
                }
            }
            this.setStagedInfo(n2, date);
            this.setNonDisruptiveApplyInfo(n3);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- setStagedLevel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStagableLevel(File file) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> setStagableLevel()");
        this.updateCollections = new ArrayList();
        this.setStagedLevel();
        BufferedReader bufferedReader = null;
        Integer n = stagableLock;
        synchronized (n) {
            int n2;
            int n3;
            block26: {
                n3 = this.stagedLevel;
                n2 = this.nonDisruptiveApplyLevel;
                this.stagableCoverLetter = this.stagedCoverLetter;
                int n4 = this.stagableLevel;
                if (this.stagableCoverLetter == null) {
                    n4 = -1;
                }
                if (-1 == n2) {
                    n2 = this.appliedLevel;
                }
                try {
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        char[] cArray = new char[(int)file.length()];
                        int n5 = 0;
                        int n6 = 0;
                        while ((long)n5 < file.length() && n6 != -1) {
                            n6 = bufferedReader.read(cArray, 0, (int)file.length());
                            Trace.trace((String)TRACE_MASKD, (Object)("readThisTime = " + n6));
                            n5 += n6;
                        }
                        String string = new String(cArray);
                        string = string.toUpperCase();
                        Trace.trace((String)TRACE_MASKD, (Object)("fixPacks=[" + string + "]"));
                        String string2 = this.ecNumber + "_";
                        Trace.trace((String)TRACE_MASKD, (Object)("testString=[" + string2 + "]"));
                        this.somethingStagable = false;
                        int n7 = string.indexOf(string2);
                        while (n7 != -1) {
                            Trace.trace((String)TRACE_MASKD, (Object)("index= " + n7));
                            String string3 = string.substring(n7, n7 + 19);
                            if (string3.startsWith(string2)) {
                                Trace.trace((String)TRACE_MASKD, (Object)("nextName=[" + string3 + "]"));
                                int n8 = string3.lastIndexOf(".");
                                Trace.trace((String)TRACE_MASKD, (Object)("dotIndex=" + n8));
                                if (n8 == 15) {
                                    String string4 = string3.substring(n8 + 1);
                                    Trace.trace((String)TRACE_MASKD, (Object)("extension=[" + string4 + "]"));
                                    if (string4.equalsIgnoreCase("rpm")) {
                                        String string5 = " " + System.getProperty("line.separator");
                                        if (-1 != string5.indexOf(string.charAt(n7 + 19))) {
                                            String string6 = string3.substring(0, 16) + "xml";
                                            Trace.trace((String)TRACE_MASKD, (Object)("coverLetterFile=[" + string6 + "]"));
                                            int n9 = string.indexOf(string6.toUpperCase());
                                            Trace.trace((String)TRACE_MASKD, (Object)("coverLetterIndex=" + n9));
                                            if (n9 != -1 && -1 != string5.indexOf(string.charAt(n9 + 19))) {
                                                Trace.trace((String)TRACE_MASKD, (Object)("The file [" + string3 + "] is an RPM in the EC stream"));
                                                int n10 = Integer.parseInt(string3.substring(8, 11));
                                                Trace.trace((String)TRACE_MASKD, (Object)("level= " + n10));
                                                int n11 = Integer.parseInt(string3.substring(12, 15));
                                                Trace.trace((String)TRACE_MASKD, (Object)("lastDisruptive= " + n11));
                                                if (n10 >= this.stagedLevel) {
                                                    this.somethingStagable = true;
                                                }
                                                if (n10 > n3) {
                                                    n3 = n10;
                                                }
                                                if (n10 > n4) {
                                                    Trace.trace((String)TRACE_MASKD, (Object)("stagableCoverLetterLevel= " + n4));
                                                    this.stagableCoverLetter = string6;
                                                    n4 = n10;
                                                }
                                                if (n10 > n2 && n11 <= this.appliedLevel) {
                                                    n2 = n10;
                                                }
                                                this.addUpdateCollectionLevel(n10);
                                            } else {
                                                Trace.trace((String)TRACE_MASKF, (Object)("RPM [" + string3 + "] found. But there is no cover letter to go with it."));
                                            }
                                        } else {
                                            Trace.trace((String)TRACE_MASKD, (Object)("Not a fixpack because [" + string.charAt(n7 + 19) + "] is not whitespace."));
                                        }
                                    }
                                }
                            }
                            n7 = string.indexOf(string2, n7 + 1);
                        }
                        Object var22_23 = null;
                        if (bufferedReader == null) break block26;
                    }
                    catch (IOException iOException) {
                        Trace.trace((String)TRACE_MASKD, (Object)("I/O Exception reading file containing list of fixpacks received from RETAIN " + iOException));
                        PIUpdateException pIUpdateException = new PIUpdateException(-1888, iOException);
                        throw pIUpdateException;
                    }
                }
                catch (Throwable throwable) {
                    Object var22_24 = null;
                    if (bufferedReader == null) throw throwable;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        Trace.trace((String)TRACE_MASKD, (Object)("I/O Exception closing file containing list of fixpacks received from RETAIN " + iOException));
                        PIUpdateException pIUpdateException = new PIUpdateException(-1887, iOException);
                        throw pIUpdateException;
                    }
                }
                try {}
                catch (IOException iOException) {
                    Trace.trace((String)TRACE_MASKD, (Object)("I/O Exception closing file containing list of fixpacks received from RETAIN " + iOException));
                    PIUpdateException pIUpdateException = new PIUpdateException(-1887, iOException);
                    throw pIUpdateException;
                }
                bufferedReader.close();
            }
            if (n2 == this.appliedLevel) {
                n2 = -1;
            }
            Trace.trace((String)TRACE_MASKD, (Object)("Setting stagable level to " + n3 + " stagable concurrent to " + n2));
            this.setStagableInfo(n3);
            this.setNonDisruptiveStagableInfo(n2);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- setStagableLevel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStagableLevel(Collection collection, boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> setStagableLevel()");
        Trace.trace((String)TRACE_MASKD, (Object)("checkCoverLetter=" + (bl ? "true" : "false")));
        Trace.trace((String)TRACE_MASKD, (Object)("fixpackFileNames.size()=" + collection.size()));
        this.updateCollections = new ArrayList();
        this.setStagedLevel();
        Integer n = stagableLock;
        synchronized (n) {
            int n2 = this.stagedLevel;
            int n3 = this.nonDisruptiveApplyLevel;
            this.stagableCoverLetter = this.stagedCoverLetter;
            int n4 = this.stagableLevel;
            if (this.stagableCoverLetter == null) {
                n4 = -1;
            }
            if (-1 == n3) {
                n3 = this.appliedLevel;
            }
            this.somethingStagable = false;
            String string = this.ecNumber + "_";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                string2 = string2.toUpperCase();
                Trace.trace((String)TRACE_MASKD, (Object)("nextName=[" + string2 + "]"));
                if (!string2.startsWith(string)) continue;
                int n5 = string2.lastIndexOf(".");
                Trace.trace((String)TRACE_MASKD, (Object)("dotIndex=" + n5));
                if (n5 != 15) continue;
                String string3 = string2.substring(n5 + 1);
                Trace.trace((String)TRACE_MASKD, (Object)("extension=[" + string3 + "]"));
                if (!string3.equalsIgnoreCase("rpm")) continue;
                String string4 = string2.substring(0, 16) + "xml";
                boolean bl2 = false;
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    String string5 = (String)iterator2.next();
                    Trace.trace((String)TRACE_MASKD, (Object)("nextName2=[" + string5 + "] coverLetterFile=[" + string4 + "]"));
                    if (!string5.equalsIgnoreCase(string4)) continue;
                    bl2 = true;
                }
                if (bl2 || !bl) {
                    Trace.trace((String)TRACE_MASKD, (Object)("The file [" + string2 + "] is an RPM in the EC stream"));
                    int n6 = Integer.parseInt(string2.substring(8, 11));
                    Trace.trace((String)TRACE_MASKD, (Object)("level= " + n6));
                    int n7 = Integer.parseInt(string2.substring(12, 15));
                    Trace.trace((String)TRACE_MASKD, (Object)("lastDisruptive= " + n7));
                    if (n6 >= this.stagedLevel) {
                        this.somethingStagable = true;
                    }
                    if (n6 > n2) {
                        n2 = n6;
                    }
                    if (n6 > n4) {
                        Trace.trace((String)TRACE_MASKD, (Object)("stagableCoverLetterLevel= " + n4));
                        this.stagableCoverLetter = string4;
                        n4 = n6;
                    }
                    if (n6 > n3 && n7 <= this.appliedLevel) {
                        n3 = n6;
                    }
                    this.addUpdateCollectionLevel(n6);
                    continue;
                }
                Trace.trace((String)TRACE_MASKF, (Object)("RPM [" + string2 + "] found. But there is no cover letter to go with it."));
            }
            if (n3 == this.appliedLevel) {
                n3 = -1;
            }
            Trace.trace((String)TRACE_MASKD, (Object)("Setting stagable level to " + n2 + " stagable concurrent to " + n3));
            this.setStagableInfo(n2);
            this.setNonDisruptiveStagableInfo(n3);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- setStagableLevel()");
    }

    public void setUpdatingEnabled(boolean bl) throws HException {
        Trace.trace((String)TRACE_MASKT, (Object)"->setUpdatingEnabled()");
        try {
            short s = 1;
            if (!bl) {
                s = 2;
            }
            Trace.trace((String)TRACE_MASKD, (Object)("Calling setCodeUpdateOwner for master owner=" + s));
            this.fsp.setCodeUpdateOwner("master", s);
            PIUpdatesOwner pIUpdatesOwner = (PIUpdatesOwner)super.getOwner();
            if (pIUpdatesOwner.doesCECHaveSlaveFSP()) {
                Trace.trace((String)TRACE_MASKD, (Object)("Calling setCodeUpdateOwner for slave owner=" + s));
                this.fsp.setCodeUpdateOwner("slave", s);
            }
            Trace.trace((String)TRACE_MASKD, (Object)"setCodeUpdateOwner completed successfully for both sides");
        }
        catch (PIHscClientException pIHscClientException) {
            PIUpdateException pIUpdateException = new PIUpdateException(-1882, pIHscClientException);
            throw pIUpdateException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-setUpdatingEnabled()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHMCandCECLevels() throws HException {
        Object object;
        Object object2;
        Trace.trace((String)TRACE_MASKT, (Object)"->setHMCandCECLevels()");
        boolean bl = PIUpdatesOwner.isTSideActive(this.fsp);
        boolean bl2 = PIUpdatesOwner.isTSideNext(this.fsp);
        int n = 0;
        int n2 = 0;
        CommonMarkerLID commonMarkerLID = null;
        File file = new File("/opt/ccfw/data/overrides/ECAndLevels");
        if (file.exists()) {
            String string;
            object2 = PIUpdatesOwner.readFileIntoString(file);
            object = new StringTokenizer((String)object2, " ");
            this.ecNumber = ((StringTokenizer)object).nextToken();
            if (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                Trace.trace((String)TRACE_MASKD, (Object)("levelAsString=[" + string + "]"));
                n = Integer.parseInt(string);
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                Trace.trace((String)TRACE_MASKD, (Object)("levelAsString=[" + string + "]"));
                n2 = Integer.parseInt(string);
            }
        } else {
            object2 = super.getOwner();
            synchronized (object2) {
                Trace.trace((String)TRACE_MASKD, (Object)"Entering synchronized block.");
                commonMarkerLID = new CommonMarkerLID(this.fsp, bl);
                this.ecNumber = this.packageIdentifier + commonMarkerLID.getPlatformID() + commonMarkerLID.getServicePackID();
                object = new CommonMarkerLID(this.fsp, !bl);
                n = commonMarkerLID.getLevel();
                n2 = ((CommonMarkerLID)object).getLevel();
                Trace.trace((String)TRACE_MASKD, (Object)"Leaving synchronized block.");
            }
        }
        Trace.trace((String)TRACE_MASKD, (Object)("ecNumber is [" + this.ecNumber + "]"));
        Trace.trace((String)TRACE_MASKD, (Object)("currentLevel = " + n + " nextLevel = " + n2));
        object2 = new Date();
        if (bl == bl2) {
            Trace.trace((String)TRACE_MASKD, (Object)"Active IPLed side matches next IPL side.");
            this.setApplyInProgressInfo(n, (Date)object2);
            this.setAppliedInfo(n, (Date)object2);
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)"Active IPLed side does NOT match next IPL side.");
            this.setApplyInProgressInfo(n2, (Date)object2);
            this.setAppliedInfo(n, (Date)object2);
        }
        int n3 = n2 > n ? n : n2;
        this.setCommittedInfo(n3, (Date)object2);
        this.setStagedLevel();
        boolean bl3 = true;
        boolean bl4 = bl;
        if (!this.concurrentEnabledFile.exists()) {
            bl4 = false;
        }
        if (this.appliedLevel > this.committedLevel && bl4 && bl3) {
            boolean bl5 = false;
            file = new File("/opt/ccfw/data/overrides/DiffFileFound");
            if (file.exists()) {
                String string = PIUpdatesOwner.readFileIntoString(file);
                if (string.equals("Y")) {
                    bl5 = true;
                }
            } else {
                for (int i = 0; i < 2 && !bl5; ++i) {
                    PIUpdateException pIUpdateException;
                    try {
                        Object object3;
                        UnsignedInt8 unsignedInt8;
                        UnsignedInt64 unsignedInt64;
                        PIUpdateException pIUpdateException2;
                        Trace.trace((String)TRACE_MASKD, (Object)("Calling getFirmwareUpdateStatus tries=" + i));
                        Vector vector = this.fsp.getFirmwareUpdateStatus("master");
                        Trace.trace((String)TRACE_MASKD, (Object)("getFirmwareUpdateStatus returned. results.size()=" + vector.size()));
                        if (vector.size() < 8) {
                            pIUpdateException2 = new PIUpdateException(-1880, "getFirmwareUpdateStatus returned bad vector. results.size()=" + vector.size());
                            throw pIUpdateException2;
                        }
                        if (vector.elementAt(0) instanceof CIMValue) {
                            pIUpdateException = (UnsignedInt16)((CIMValue)vector.elementAt(0)).getValue();
                            unsignedInt64 = (UnsignedInt64)((CIMValue)vector.elementAt(5)).getValue();
                            unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(6)).getValue();
                        } else {
                            pIUpdateException = (UnsignedInt16)((CIMProperty)vector.elementAt(0)).getValue().getValue();
                            unsignedInt64 = (UnsignedInt64)((CIMProperty)vector.elementAt(5)).getValue().getValue();
                            unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(6)).getValue().getValue();
                        }
                        Trace.trace((String)TRACE_MASKD, (Object)("getFirmwareUpdateStatus retcode = " + pIUpdateException));
                        pIUpdateException2 = new UnsignedInt16(0);
                        boolean bl6 = false;
                        if (pIUpdateException.equals(pIUpdateException2)) {
                            Trace.trace((String)TRACE_MASKD, (Object)("getFirmwareUpdateStatus vrm = " + unsignedInt64));
                            object3 = new BigNumberComparator();
                            if (0 == ((BigNumberComparator)object3).compare(unsignedInt64, pIUpdateException2)) {
                                Object object4;
                                Trace.trace((String)TRACE_MASKF, (Object)"The PHYP DIFF file is not in memory.");
                                if (i != 0 || commonMarkerLID == null) continue;
                                int n4 = commonMarkerLID.getLastDisruptivePHYPLevel();
                                if (n4 >= n3) {
                                    i = 2;
                                    continue;
                                }
                                Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
                                Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
                                Vector<UnsignedInt8> vector4 = new Vector<UnsignedInt8>();
                                Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
                                Vector<UnsignedInt32> vector6 = new Vector<UnsignedInt32>();
                                Vector<UnsignedInt32> vector7 = new Vector<UnsignedInt32>();
                                int n5 = 1;
                                UnsignedInt16 unsignedInt16 = new UnsignedInt16(n5);
                                vector2.add(unsignedInt16);
                                long l = 1L;
                                UnsignedInt32 unsignedInt32 = new UnsignedInt32(l);
                                vector3.add(unsignedInt32);
                                l = 0L;
                                UnsignedInt32 unsignedInt322 = new UnsignedInt32(l);
                                vector6.add(unsignedInt322);
                                short s = 3;
                                UnsignedInt8 unsignedInt82 = new UnsignedInt8(s);
                                vector4.add(unsignedInt82);
                                short s2 = 0;
                                UnsignedInt8 unsignedInt83 = new UnsignedInt8(s2);
                                vector5.add(unsignedInt83);
                                UnsignedInt32 unsignedInt323 = new UnsignedInt32(l);
                                vector7.add(unsignedInt323);
                                try {
                                    Trace.trace((String)TRACE_MASKD, (Object)("Calling openPhypFile openType=" + s));
                                    Trace.trace((String)TRACE_MASKD, (Object)("Opening to write " + vector7.firstElement() + " bytes to offset " + vector6.firstElement() + " in flash."));
                                    Hashtable hashtable = this.fsp.openPhypFile("master", vector2, vector3, vector4, vector5, vector6, vector7);
                                    object4 = (Vector)hashtable.get("ReturnCode");
                                    if (object4 == null) {
                                        Trace.trace((String)TRACE_MASKD, (Object)"Could not pull ReturnCode of openPhypFile");
                                    }
                                    UnsignedInt16 unsignedInt162 = (UnsignedInt16)((Vector)object4).firstElement();
                                    Trace.trace((String)TRACE_MASKD, (Object)("openPhypFile returnCode=" + unsignedInt162));
                                    if (unsignedInt162.equals((Object)pIUpdateException2)) continue;
                                    PIUpdateException pIUpdateException3 = new PIUpdateException(-1938, "openPhypFile retcode=" + unsignedInt162);
                                    throw pIUpdateException3;
                                }
                                catch (Exception exception) {
                                    object4 = new PIUpdateException(-1951, exception);
                                    throw object4;
                                }
                            }
                            Trace.trace((String)TRACE_MASKF, (Object)"The PHYP DIFF file is in memory.");
                            bl5 = true;
                            continue;
                        }
                        object3 = new PIUpdateException(-1885, "getFirmwareUpdateStatus retcode=" + pIUpdateException + " Error=" + unsignedInt8);
                        throw object3;
                    }
                    catch (PIHscClientException pIHscClientException) {
                        pIUpdateException = new PIUpdateException(-1884, pIHscClientException);
                        throw pIUpdateException;
                    }
                }
            }
            if (!bl5) {
                bl4 = false;
            }
        }
        if (bl4 && this.appliedLevel > this.committedLevel) {
            this.nonDisruptiveRejectLevel = this.committedLevel + 1;
            if (this.nonDisruptiveRejectLevel == 0) {
                this.nonDisruptiveRejectLevel = 1;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-setHMCandCECLevels()");
    }

    private void addUpdateCollectionLevel(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)"->addUpdateCollectionLevel()");
        if (n != this.appliedLevel) {
            int n2;
            Integer n3 = new Integer(n);
            Trace.trace((String)TRACE_MASKD, (Object)("newLevel = " + n3));
            int n4 = this.updateCollections.size();
            for (n2 = 0; n2 < n4; ++n2) {
                Integer n5 = (Integer)this.updateCollections.get(n2);
                Trace.trace((String)TRACE_MASKD, (Object)("nextLevel = " + n5));
                if (n3.equals(n5)) break;
                if (n3.compareTo(n5) <= 0) continue;
                this.updateCollections.add(n2, n3);
                Trace.trace((String)TRACE_MASKD, (Object)("newLevel = " + n3 + " added at position " + n2));
                break;
            }
            if (n2 == n4) {
                this.updateCollections.add(n3);
                Trace.trace((String)TRACE_MASKD, (Object)("newLevel = " + n3 + " added at the end."));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-addUpdateCollectionLevel()");
    }

    protected void setNewAvailableECs(File file) {
        String string;
        Trace.trace((String)TRACE_MASKT, (Object)"->setNewAvailableECs()");
        String string2 = this.ecNumber.substring(2, 4);
        Trace.trace((String)TRACE_MASKD, (Object)("genus = [" + string2 + "]"));
        boolean bl = false;
        String string3 = string = file.getPath();
        while (!bl) {
            Trace.trace((String)TRACE_MASKD, (Object)("pathToCheck = [" + string + "]"));
            File file2 = new File(string);
            String[] stringArray = file2.list(new NewECStreamFilter(this.ecNumber));
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Trace.trace((String)TRACE_MASKD, (Object)("fixpacks[" + i + "] = [" + stringArray[i] + "]"));
                    String string4 = stringArray[i].substring(2, 4);
                    if (string2.equalsIgnoreCase(string4)) {
                        this.setNewGAEcStream(stringArray[i].substring(0, 7));
                        continue;
                    }
                    this.setNewGenusEcStream(stringArray[i].substring(0, 7));
                }
            }
            if (string.equals(string3)) {
                string = string + "/microcode/SqnP5/";
                continue;
            }
            bl = true;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-setNewAvailableECs()");
    }
}

